/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.metal;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.player.CapabilityPlayerData;
import net.dries007.tfc.api.capability.player.IPlayerData;
import net.dries007.tfc.api.recipes.ChiselRecipe;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.api.util.FallingBlockManager;
import net.dries007.tfc.objects.blocks.stone.BlockRockSmooth;
import net.dries007.tfc.objects.blocks.wood.BlockSupport;
import net.dries007.tfc.objects.container.ContainerEmpty;
import net.dries007.tfc.objects.items.metal.ItemMetalTool;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@ParametersAreNonnullByDefault
public class ItemMetalChisel
extends ItemMetalTool {
    private static final int[] STAIR_PATTERN_INDICES = new int[]{0, 3, 4, 6, 7, 8};
    private static final int[] SLAB_PATTERN_INDICES = new int[]{0, 1, 2};
    private static final int COOLDOWN = 10;

    @Nullable
    public static IBlockState getChiselResultState(EntityPlayer player, World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (ItemMetalChisel.hasHammerForChisel(player)) {
            IBlockState state = worldIn.func_180495_p(pos);
            IPlayerData capability = (IPlayerData)player.getCapability(CapabilityPlayerData.CAPABILITY, null);
            if (capability != null) {
                return ItemMetalChisel.getRecipeResult(player, worldIn, pos, facing, capability.getChiselMode(), state, hitX, hitY, hitZ);
            }
        }
        return null;
    }

    public static boolean hasHammerForChisel(EntityPlayer player) {
        if (OreDictionaryHelper.doesStackMatchOre((ItemStack)player.field_71071_by.field_184439_c.get(0), "hammer")) {
            return true;
        }
        if (!ConfigTFC.Devices.CHISEL.requireHammerInOffHand) {
            for (int i = 0; i < 9; ++i) {
                if (!OreDictionaryHelper.doesStackMatchOre((ItemStack)player.field_71071_by.field_70462_a.get(i), "hammer")) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static IBlockState getRecipeResult(EntityPlayer player, World worldIn, BlockPos pos, EnumFacing facing, ChiselRecipe.Mode chiselMode, IBlockState targetState, float hitX, float hitY, float hitZ) {
        Item resultItem;
        ItemStack targetStack;
        ItemStack resultItemStack;
        if (chiselMode == ChiselRecipe.Mode.SMOOTH) {
            ChiselRecipe recipe = ChiselRecipe.get(targetState);
            if (recipe != null) {
                return recipe.getOutputState();
            }
        } else if ((chiselMode == ChiselRecipe.Mode.SLAB || chiselMode == ChiselRecipe.Mode.STAIR) && (resultItemStack = ItemMetalChisel.findCraftingResult(worldIn, targetStack = targetState.func_177230_c().getPickBlock(targetState, null, worldIn, pos, player), chiselMode == ChiselRecipe.Mode.SLAB ? SLAB_PATTERN_INDICES : STAIR_PATTERN_INDICES)) != null && (resultItem = resultItemStack.func_77973_b()) instanceof ItemBlock) {
            Block block = ((ItemBlock)resultItem).func_179223_d();
            if (chiselMode == ChiselRecipe.Mode.SLAB && block instanceof BlockSlab || chiselMode == ChiselRecipe.Mode.STAIR && block instanceof BlockStairs) {
                if (facing.func_176740_k().func_176716_d() != EnumFacing.Plane.VERTICAL) {
                    hitY = 1.0f - hitY;
                }
                return block.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, resultItemStack.func_77960_j(), (EntityLivingBase)player);
            }
        }
        return null;
    }

    @Nullable
    private static ItemStack findCraftingResult(World world, ItemStack craftingIngredient, int[] craftingIndices) {
        InventoryCrafting craftMatrix = new InventoryCrafting((Container)new ContainerEmpty(), 3, 3);
        for (int index : craftingIndices) {
            craftMatrix.func_70299_a(index, craftingIngredient.func_77946_l());
        }
        Object object = ForgeRegistries.RECIPES.getValuesCollection().iterator();
        while (object.hasNext()) {
            ItemStack stackOut;
            IRecipe recipe = (IRecipe)object.next();
            if (!recipe.func_77569_a(craftMatrix, world) || !((stackOut = recipe.func_77572_b(craftMatrix)).func_77973_b() instanceof ItemBlock)) continue;
            return stackOut;
        }
        return null;
    }

    public ItemMetalChisel(Metal metal, Metal.ItemType type) {
        super(metal, type);
    }

    @Override
    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState newState = ItemMetalChisel.getChiselResultState(player, worldIn, pos, facing, hitX, hitY, hitZ);
        if (newState != null) {
            SoundType soundType = newState.func_177230_c().getSoundType(newState, worldIn, pos, (Entity)player);
            worldIn.func_184133_a(player, pos, soundType.func_185846_f(), SoundCategory.BLOCKS, 1.0f, soundType.func_185847_b());
            if (!worldIn.field_72995_K) {
                IBlockState oldState;
                FallingBlockManager.Specification oldSpec;
                if (ConfigTFC.General.FALLABLE.chiselCausesCollapse && (oldSpec = FallingBlockManager.getSpecification(oldState = worldIn.func_180495_p(pos))) != null && oldSpec.isCollapsable() && !BlockSupport.isBeingSupported(worldIn, pos)) {
                    worldIn.func_175698_g(pos);
                    if (FallingBlockManager.checkCollapsingArea(worldIn, pos)) {
                        return EnumActionResult.SUCCESS;
                    }
                }
                if (newState.func_177228_b().containsKey((Object)BlockRockSmooth.CAN_FALL)) {
                    newState = newState.func_177226_a((IProperty)BlockRockSmooth.CAN_FALL, (Comparable)Boolean.valueOf(true));
                }
                worldIn.func_175656_a(pos, newState);
                IPlayerData capability = (IPlayerData)player.getCapability(CapabilityPlayerData.CAPABILITY, null);
                if (capability != null && capability.getChiselMode() == ChiselRecipe.Mode.SLAB) {
                    InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)new ItemStack(newState.func_177230_c(), 1));
                }
                player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
                if (ConfigTFC.Devices.CHISEL.hasDelay) {
                    player.func_184811_cZ().func_185145_a((Item)this, 10);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }
}

